module.exports = {
  name: "Waifu",
  desc: "Random foto Anime Waifu",
  category: "Random",
  parameters: {
    apikey: { type: "string" }
  },   
  path: "/random/waifu",
  async run(req, res) {
    const { apikey } = req.query;
    if (!apikey) {
      return res.json({ status: false, error: 'Apikey invalid' });
    }

    try {
      const data = await fetchJson(`https://api.waifu.pics/sfw/waifu`);
      const image = await getBuffer(data.url);

      res.writeHead(200, {
        'Content-Type': 'image/png',
        'Content-Length': image.length
      });
      res.end(image);
    } catch (error) {
      res.status(500).json({ status: false, error: error.message });
    }
  }
};